<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\AllegroCategory;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Entity\AllegroCategoryItemType;

/**
 * AllegroCategoryRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class AllegroCategoryItemRepository extends EntityRepository
{
    /**
     * add new AllegroCategoryItem from AllegroStructure
     *
     * @param $data
     * @param bool $flush
     * @return bool|AllegroCategoryItem|object
     */
    public function addFromAllegroStructure($data, $flush = false)
    {
        $AllegroCategoryItem = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroCategoryItem')->findOneBy(array('item_id' => $data->{'s-it-id'}));
        if(!empty($AllegroCategoryItem))
        {
            return false;
        }

        $AllegroCategoryItem = new AllegroCategoryItem();

        $AllegroCategoryItem->setItemId($data->{'s-it-id'});
        $AllegroCategoryItem->setName($data->{'s-it-name'});
        $AllegroCategoryItem->setBuyNowPrice($data->{'s-it-buy-now-price'});
        $endingTime = new \DateTime();
        $endingTime->setTimestamp($data->{'s-it-ending-time'});
        $AllegroCategoryItem->setEndingTime($endingTime);
        $AllegroCategoryItem->setCity($data->{'s-it-city'});
        $AllegroCategoryItem->setState($data->{'s-it-state'});
        $AllegroCategoryItem->setCountry($data->{'s-it-country'});
        $AllegroCategory = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroCategory')->findOneBy(array('cat_id' => $data->{'s-it-category-id'}));
        $AllegroCategoryItem->setCategory($AllegroCategory);
        $AllegroCategoryItem->setThumbUrl($data->{'s-it-thumb-url'});
        $AllegroCategoryItemAdvertService = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroCategoryItemAdvertService')->find($data->{'s-it-advert-info'}->{'item-is-advert'});
        $AllegroCategoryItem->setAdvertService($AllegroCategoryItemAdvertService);
        $AllegroCategoryItem->setIdInAdvertService($data->{'s-it-advert-info'}->{'item-advert-id'});
        $AllegroCategoryItem->setType($data->{'AllegroCategoryItemType'});
        $data->{'AllegroCategoryItemType'}->addItem($AllegroCategoryItem);
        $AllegroUser = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroUser')->findOneBy(array('user_id' => $data->{'s-it-seller-info'}->{'seller-id'}));
        if(empty($AllegroUser))
        {
            $AllegroUser = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroUser')->addFromAllegroStructure($data->{'s-it-seller-info'});
        }
        $AllegroCategoryItem->setUser($AllegroUser);

        foreach($data->{'s-it-attribs-list'} as $attribute)
        {
            $AllegroCategoryItemAttribute = $this->getEntityManager()->getRepository('ImportApiBundle:AllegroCategoryItemAttributes')->addFromAllegroStructure($attribute,$AllegroCategoryItem);
            $AllegroCategoryItem->addAttribute($AllegroCategoryItemAttribute);

            if($attribute->{'attrib-name'} == "Powierzchnia")
            {
                $AllegroCategoryItem->setSurface($attribute->{'attrib-values'}[0]);
            }
        }

        $this->setRandomBail($AllegroCategoryItem);
        $this->setRandomPeriodOfNotice($AllegroCategoryItem);

        $this->getEntityManager()->persist($AllegroCategoryItem);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $AllegroCategoryItem;
    }

    private function setRandomBail(AllegroCategoryItem $AllegroCategoryItem)
    {
        $randForBail = $this->generateRandValue(0,100,array('1' => 85, '1.5' => 10, '2' => 5));
        $bail = round($AllegroCategoryItem->getBuyNowPrice() * ((float)$randForBail),2);

        $AllegroCategoryItem->setBail($bail);
    }

    private function setRandomPeriodOfNotice(AllegroCategoryItem $AllegroCategoryItem)
    {
        $randForPeriodOfNotice = $this->generateRandValue(0,100,array('1' => 50, '2' => 80, '3' => 20));

        $AllegroCategoryItem->setPeriodOfNotice((int)$randForPeriodOfNotice);
    }


    private function generateRandValue($min = 0, $max = 100, Array $param = array())
    {
        $rand = rand($min,$max);
        $randValue = $rand;
        $limitCount = 0;

        foreach($param as $value => $limit)
        {
            $limitCount += $limit;
            if($rand <= $limitCount)
            {
                $randValue = $value;
                break;
            }
        }

        return $randValue;
    }
}
